import { Routing } from "@/types/app";
import { Cog, Send } from "lucide-react";
import type { Metadata } from "next";

export const DEFAULT_AUTHENTICATED_REDIRECT_URL = "/portal/engagement" satisfies ValidUrlRedirect
export const DEFAULT_AUTHENTICATED_SETTINGS_REDIRECT_URL = "/settings/user-management" //satisfies ValidUrlRedirect
export const DEFAULT_UNAUTHENTICATED_REDIRECT_URL = "/login"
export const DEFAULT_UNAUTHORIZED_REDIRECT_URL = "/unauthorized"

export const metadata: Metadata = {
  title: {
    default: "Administration Dashboard - MDOT GTFS",
    template: "%s - Administration",
  },
  description: "System level admin portal for interacting with Michigan DOT GTFS Platform",
  keywords: ["admin", "otp", "gtfs"],
  openGraph: {
    type: "website",
    locale: "en_US",
    url: "",
    title: "Administration Dashboard - MDOT GTFS",
    description: "System level admin portal for interacting with Michigan DOT GTFS Platform",
    siteName: "Administraion Dashboard",
    images: [
      {
        url: "",
        width: 1200,
        height: 630,
        alt: "Administration Dashboard",
      }
    ]

  },
  icons: {
    icon: "/favicon.ico",
    shortcut: "/favicon-16x16.png",
    apple: "/apple-touch-icon.png",
  },
};

const INTERNAL__routing = {
  navigation: [
    {
      title: "Portal",
      enabled: true,
      items: [
        {
          title: "Engagement",
          enabled: true,
          url: "/portal/engagement",
        },
      ]
    },
    {
      title: "Agency",
      enabled: true,
      items: [
        {
          title: "Feeds",
          enabled: true,
          url: "/agency/feeds",
        },
        {
          title: "Statewide Services",
          enabled: true,
          url: "/agency/statewide-services",
        },
      ]
    },
  ],
  actions: [
    {
      title: "Settings",
      url: DEFAULT_AUTHENTICATED_SETTINGS_REDIRECT_URL,
      icon: <Cog />,
      enabled: true,
    },
    {
      title: "Feedback",
      url: "#",
      icon: <Send />,
      enabled: false,
    },
  ],

  settings: [
    {
      title: "User Management",
      url: "/settings/user-management",
      // icon: <Users className="size-3" />,
      enabled: true,
    },
  ],
} as const satisfies Routing

export const routing: Routing = INTERNAL__routing

export type ValidUrlRedirect = (typeof INTERNAL__routing)['navigation'][number]['items'][number]['url'] | (typeof INTERNAL__routing)['actions'][number]['url']
